/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.green;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAllEnemiesAction;
import com.megacrit.cardcrawl.actions.unique.CorpseExplosionAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.vfx.ThoughtBubble;

public class CorpseExplosion
extends AbstractCard {
    public static final String ID = "Corpse Explosion";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Corpse Explosion");
    public static final String NAME = CorpseExplosion.cardStrings.NAME;
    public static final String DESCRIPTION = CorpseExplosion.cardStrings.DESCRIPTION;
    public static final String UPGRADE_DESCRIPTION = CorpseExplosion.cardStrings.UPGRADE_DESCRIPTION;
    public static final String[] EXTENDED_DESCRIPTION = CorpseExplosion.cardStrings.EXTENDED_DESCRIPTION;
    private static final int COST = 2;
    private static final int POOL = 2;

    public CorpseExplosion() {
        super(ID, NAME, null, "green/attack/corpseExplosion", 2, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.GREEN, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.ENEMY, 2);
        this.isMultiDamage = true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        if (m.getPower("Poison") == null) {
            AbstractDungeon.effectList.add(new ThoughtBubble(p.dialogX, p.dialogY, 3.0f, EXTENDED_DESCRIPTION[0], true));
            return;
        }
        this.baseDamage = m.getPower((String)"Poison").amount;
        this.baseDamage = !this.upgraded ? (this.baseDamage *= 2) : (this.baseDamage *= 3);
        this.calculateCardDamage(m);
        AbstractDungeon.actionManager.addToBottom(new DamageAllEnemiesAction(p, this.multiDamage, DamageInfo.DamageType.NORMAL, AbstractGameAction.AttackEffect.POISON, false));
        AbstractDungeon.actionManager.addToBottom(new CorpseExplosionAction(m, p));
    }

    @Override
    public AbstractCard makeCopy() {
        return new CorpseExplosion();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.rawDescription = UPGRADE_DESCRIPTION;
            this.initializeDescription();
        }
    }
}

